<?php
/* --------------------------------------------------------------
   LogfileServiceInterface.php 2024-07-23
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2018 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Modules\Logfiles\Interfaces;



use Doctrine\DBAL\Exception;

interface LogfileServiceInterface
{


    /**
     * @return array<string, array<int, string>>
     */
    public function deleteOldLogFiles(): array;

    /**
     * Get array of all log files
     *
     * @return array<int, array<string, string>>
     */
    public function getLogFiles(): array;


    /**
     *
     * @throws Exception
     * @return array<string, bool|int|null>
     */
    public function loadConfigFromDatabase(): array;

    /**
     * @param array $conJobDependencies
     * @return void
     */
    public function setDependencies(array $cronJobDependencies): void;


}